// API路径配置文件
// 这个文件确保所有API路径在一处统一管理，方便修改

import { pauseJob } from "./schedule"

export const authApi = {
  login: '/auth/login',
  logout: '/auth/logout'
} as const

export const scrapydApi = {
  // scrapyd相关接口
  listProjects: '/scrapyd/listProjects',
  listVersions: '/scrapyd/listVersions',
  listSpiders: '/scrapyd/listSpiders',
  listJobsMerge: '/scrapyd/listJobsMerge',
  cancel: '/scrapyd/cancel',
  cancelAllJob: '/scrapyd/cancelAllJob',
  deleteVersion: '/scrapyd/deleteVersion',
  deleteProject: '/scrapyd/deleteProject',
  schedule: '/scrapyd/schedule',
  daemonStatus: '/scrapyd/daemonStatus',
  addVersion: '/scrapyd/addVersion',

  // 日志相关
  logs: '/scrapyd/logs',
  projectLogs: '/scrapyd/projectLogs',
  spiderLogs: '/scrapyd/spiderLogs',
  jobLog: '/scrapyd/jobLog'
} as const

export const scheduleApi = {
  // 调度任务相关
  addJob: '/schedule/addJob',
  getJobs: '/schedule/getJobs',
  pauseJob: '/schedule/pauseJob',
  resumeJob: '/schedule/resumeJob',
  removeJob: '/schedule/removeJob',
  jobDetail: '/schedule/jobDetail',
  state: '/schedule/state',
  start: '/schedule/start',
  shutdown: '/schedule/shutdown',
  pause: '/schedule/pause',
  resume: '/schedule/resume',
  removeAllJobs: '/schedule/removeAllJobs',
  scheduleLogs: '/schedule/scheduleLogs',
  removeScheduleLogs: '/schedule/removeScheduleLogs',
} as const

export const scrapydServerApi = {
  getScrapydServerPage: '/scrapydServer/getScrapydServerPage',
  addScrapydServer: '/scrapydServer/addScrapydServer',
  updateScrapydServer: '/scrapydServer/updateScrapydServer',
  updateScrapydServerStatus: '/scrapydServer/updateScrapydServerStatus',
  deleteScrapydServer: '/scrapydServer/deleteScrapydServer'
} as const

export const systemApi = {
  // 系统相关
  systemInfo: '/system/systemInfo',
  systemData: '/system/systemData',
  systemConfig: '/system/systemConfig',
  loginHistoryList: '/actionHistory/loginHistoryList',
  scrapydServerList: '/system/scrapydServerList'        // 没用
} as const

export const statsApi = {
  // 统计相关
  statsList: '/statsCollection/listItem',
  statsDetail: '/statsCollection/detail',
  removeStats: '/statsCollection/delete',
  clearAllStats: '/statsCollection/clearAll' // TODO 未实现
} as const

export const userApi = {
  // 系统用户相关接口
  userList: '/user/list',
  addUser: '/user/insert',
  updateUser: '/user/update',
  deleteUser: '/user/delete',
  batchDelete: '/user/batchDelete',
} as const

export const spiderApi = {
  // 系统用户相关接口
  spiderList: '/scrapyd/listSpiders',
} as const

export const spiderTaskApi = {
  // 爬虫任务相关接口
  taskList: '/schedule/getJobs',
  taskRecord: '/schedule/scheduleLogs',
  addTask: '/schedule/addJob',
  deleteTask: '/schedule/removeJob',
  pauseJob: '/schedule/pauseJob',
  resumeJob: '/schedule/resumeJob',
  jobDetail: '/schedule/jobDetail',
} as const