import { type ApiResponse, request, POST } from "@/utils/request"
import { scrapydServerApi } from "./apiPaths"

// 添加Scrapyd服务
export const addScrapydServer = (data: Record<string, any>): Promise<ApiResponse> => {
  return request({
    url: scrapydServerApi.addScrapydServer,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 更新Scrapyd服务
export const updateScrapydServer = (data: Record<string, any>): Promise<ApiResponse> => {
  return request({
    url: scrapydServerApi.updateScrapydServer,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 更新Scrapyd服务状态
export const updateScrapydServerStatus = (data: Record<string, any>): Promise<ApiResponse> => {
  return request({
    url: scrapydServerApi.updateScrapydServerStatus,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 删除Scrapyd服务
export const deleteScrapydServer = (data: Record<string, any>): Promise<ApiResponse> => {
  return request({
    url: scrapydServerApi.deleteScrapydServer,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}
