const formatExactLargeNum = (num: number | string | null) => {
  if (num === null || num === undefined) return ''
  if (typeof num !== 'number' && typeof num !== 'string') return num

  const parsedNum = typeof num === 'string' ? Number(num.replace(/,/g, '')) : num

  if (isNaN(parsedNum)) return num

  const absNum = Math.abs(parsedNum)

  if (absNum >= 100_000_000) {
    return (parsedNum / 100_000_000).toFixed(2) + '亿'
  } else if (absNum >= 10_000) {
    return (parsedNum / 10_000).toFixed(2) + '万'
  } else {
    return parsedNum.toLocaleString('en-US', {
      useGrouping: true,
      maximumFractionDigits: 2,
      minimumFractionDigits: 0
    })
  }
}

export default formatExactLargeNum
