export function isExternal(path: string): boolean {
  return /^(https?:|mailto:|tel:)/.test(path)
}

// 校验用户名
export const validateUsername = (rule: any, value: string, callback: Function) => {
  if (value.trim().length < 3) {
    callback(new Error('用户名不能少于3个字符'))
  } else {
    callback()
  }
}

// 校验密码
export const validatePassword = (rule: any, value: string, callback: Function) => {
  if (value.length < 6) {
    callback(new Error('密码不能少于6个字符'))
  } else {
    callback()
  }
}
