import { request, POST } from '@/utils/request'
import type { ApiResponse, QueryParams, UserQueryParams } from '@/utils/request'
import { spiderDataApi } from './apiPaths'

// 获取dsn数据列表
export function getDsnList(data: UserQueryParams) {
    return request({
        url: spiderDataApi.dsnList,
        method: POST,
        data
    }) as unknown as Promise<ApiResponse>
}

// 获取dsn数据详情
export function getDsnDetail(data: UserQueryParams) {
    return request({
        url: spiderDataApi.dsnDetail,
        method: POST,
        data
    }) as unknown as Promise<ApiResponse>
}

// 删除dsn数据
export function deleteDsnData(data: UserQueryParams) {
    return request({
        url: spiderDataApi.dsnDataDelete,
        method: POST,
        data
    }) as unknown as Promise<ApiResponse>
}

// 获取itu数据列表
export function getItuList(data: UserQueryParams) {
    return request({
        url: spiderDataApi.ituList,
        method: POST,
        data
    }) as unknown as Promise<ApiResponse>
}

// 获取itu数据详情
export function getItuDetail(data: UserQueryParams) {
    return request({
        url: spiderDataApi.ituDetail,
        method: POST,
        data
    }) as unknown as Promise<ApiResponse>
}

// 删除itu数据
export function deleteItuData(data: UserQueryParams) {
    return request({
        url: spiderDataApi.ituDataDelete,
        method: POST,
        data
    }) as unknown as Promise<ApiResponse>
}

// 获取st数据列表
export function getStList(data: UserQueryParams) {
    return request({
        url: spiderDataApi.stList,
        method: POST,
        data
    }) as unknown as Promise<ApiResponse>
}

// 获取st数据详情
export function getStDetail(data: UserQueryParams) {
    return request({
        url: spiderDataApi.stDetail,
        method: POST,
        data
    }) as unknown as Promise<ApiResponse>
}

// 删除st数据
export function deleteStData(data: UserQueryParams) {
    return request({
        url: spiderDataApi.stDataDelete,
        method: POST,
        data
    }) as unknown as Promise<ApiResponse>
}

// 导出爬虫数据
export function exportSpiderData(data: UserQueryParams) {
    return request({
        url: spiderDataApi.exportSpiderData,
        method: POST,
        data
    }) as unknown as Promise<ApiResponse>
}