import { createRouter, createWebHistory, type RouteRecordRaw } from 'vue-router'

import Layout from '@/layout/index.vue'

/**
 * 路由配置
 * 
 * hidden: true                   设为true则不会显示在侧边栏
 * alwaysShow: true               设为true则总是显示根菜单
 * redirect: noRedirect           设为noRedirect则不会在面包屑中重定向
 * name:'router-name'             用于 <keep-alive> (必须设置!!!)
 * meta : {
 *   roles: ['admin','editor']    控制页面角色（可设置多个角色）
 *   title: 'title'               显示在侧边栏和面包屑上的名称（推荐设置）
 *   icon: 'svg-name'             侧边栏图标
 *   breadcrumb: false            设为false则不显示在面包屑中
 *   activeMenu: '/example/list'  如果设置路径，侧边栏将高亮你设置的路径
 * }
 */

/**
 * constantRoutes
 * 没有权限要求的基础页面
 * 所有角色都可访问
 */
export const constantRoutes: Array<RouteRecordRaw> = [
  {
    path: '/login',
    component: () => import('@/views/login/index.vue'),
    meta: { title: '登录' },
    hidden: true
  } as unknown as RouteRecordRaw,

  {
    path: '/404',
    component: () => import('@/views/404.vue'),
    hidden: true
  } as unknown as RouteRecordRaw,

  {
    path: '',
    component: Layout,
    redirect: '/dashboard',
    hidden: true,
    children: [{
      path: '/dashboard',
      name: 'Dashboard',
      component: () => import('@/views/home/home.vue'),
      meta: { title: '控制台', icon: 'Monitor' }
    }]
  } as unknown as RouteRecordRaw,

  {
    path: "/scrapyd-server",
    component: Layout,
    hidden: true,
    children: [
      {
        path: "list",
        name: "scrapyd-server-list",
        component: () => import("@/views/scrapyd-server/index.vue"),
        meta: { title: "Scrapyd服务", icon: "Key" }
      },
    ]
  } as unknown as RouteRecordRaw,

  {
    path: '/project',
    component: Layout,
    hidden: true,
    redirect: '/project/list',
    name: 'project',
    meta: { title: '项目', icon: 'House' },
    children: [
      {
        path: 'list',
        name: 'project-list',
        component: () => import('@/views/project/index.vue'),
        meta: { title: '项目列表', icon: 'House' }
      },
      {
        path: 'version-list',
        name: 'project-version',
        component: () => import('@/views/project/versions.vue'),
        meta: { title: '版本列表', icon: 'List' },
        hidden: true
      }
    ]
  } as unknown as RouteRecordRaw,

  {
    path: '/spider',
    component: Layout,
    hidden: true,
    children: [
      {
        path: 'list',
        name: 'spider-list',
        component: () => import('@/views/spider/index.vue'),
        meta: { title: 'Spider', icon: 'List' }
      }
    ]
  } as unknown as RouteRecordRaw,

  {
    path: '/schedule',
    component: Layout,
    hidden: true,
    children: [
      {
        path: 'list',
        name: 'schedule-list',
        component: () => import('@/views/schedule/index.vue'),
        meta: { title: '定时任务', icon: 'Clock' }
      }
    ]
  } as unknown as RouteRecordRaw,

  {
    path: "/schedule-log",
    component: Layout,
    hidden: true,
    children: [
      {
        path: 'list',
        name: 'schedule-log-list',
        component: () => import('@/views/schedule/logs.vue'),
        meta: { title: '调度日志', icon: 'Message' },
      }
    ]
  } as unknown as RouteRecordRaw,

  {
    path: "/job",
    component: Layout,
    hidden: true,
    children: [
      {
        path: "list",
        name: "job-list",
        component: () => import("@/views/job/index.vue"),
        meta: { title: "任务列表", icon: "List" },
      }
    ]
  } as unknown as RouteRecordRaw,

  {
    path: '/stats',
    component: Layout,
    hidden: true,
    children: [
      {
        path: 'list',
        name: 'stats-list',
        component: () => import('@/views/stats/index.vue'),
        meta: { title: '数据统计', icon: 'DataAnalysis' }
      }
    ]
  } as unknown as RouteRecordRaw,

  {
    path: "/logs",
    component: Layout,
    redirect: "/logs/list",
    name: "logs",
    meta: { title: "日志", icon: "Notebook" },
    hidden: true,
    children: [
      {
        path: "list",
        name: "logs-list",
        component: () => import("@/views/log/LogIndex.vue"),
        meta: { title: "运行日志", icon: "Notebook" }
      },
      {
        path: "project",
        name: "logs-project",
        component: () => import("@/views/log/LogProject.vue"),
        meta: { title: "项目日志", icon: "Notebook" },
        hidden: true
      },
      {
        path: "spider",
        name: "logs-project-spider",
        component: () => import("@/views/log/LogSpider.vue"),
        meta: { title: "Spider日志", icon: "Notebook" },
        hidden: true
      },
      {
        path: "job",
        name: "logs-project-spider-job",
        component: () => import("@/views/log/LogJob.vue"),
        meta: { title: "任务日志", icon: "Notebook" },
        hidden: true
      }
    ]
  } as unknown as RouteRecordRaw,

  {
    path: "/system",
    component: Layout,
    redirect: "/system/login-list",
    name: "system",
    meta: { title: "系统管理", icon: "Setting" },
    hidden: true,
    children: [
      {
        path: "login-list",
        name: "system-login-list",
        component: () => import('@/views/system/SystemIndex.vue'),
        meta: { title: "登录日志", icon: "Setting" }
      },
    ]
  } as unknown as RouteRecordRaw,


  {
    path: "/osStatus",
    // redirect: "list",
    component: Layout,
    children: [
      {
        path: "list",
        name: "statusMonitor",
        component: () => import("@/views/os-status/index.vue"),
        meta: { title: "状态监控", icon: "Key" }
      },
    ]
  } as unknown as RouteRecordRaw,


  {
    path: "/osTaskInformation",
    component: Layout,
    children: [
      {
        path: "list",
        name: "taskInformation",
        component: () => import("@/views/os-taskInformation/index.vue"),
        meta: { title: "任务信息", icon: "Key" }
      },
    ]
  } as unknown as RouteRecordRaw,

  {
    path: "/osTaskRecord",
    component: Layout,
    children: [
      {
        path: "list",
        name: "taskRecord",
        component: () => import("@/views/os-taskRecord/index.vue"),
        meta: { title: "任务执行记录", icon: "Key" }
      },
    ]
  } as unknown as RouteRecordRaw,

  {
    path: "/osDataDisplay",
    component: Layout,
    children: [
      {
        path: "list",
        name: "dataDisplay",
        component: () => import("@/views/os-dataDisplay/index.vue"),
        meta: { title: "数据展示", icon: "Key" }
      },
    ]
  } as unknown as RouteRecordRaw,

  {
    path: "/osSpiderManager",
    component: Layout,
    children: [
      {
        path: "list",
        name: "osSpiderManager",
        component: () => import("@/views/os-spiderManager/index.vue"),
        meta: { title: "爬虫管理", icon: "Key" }
      },
    ]
  } as unknown as RouteRecordRaw,

  {
    path: "/osSystem",
    component: Layout,
    children: [
      {
        path: "list",
        name: "osSystem",
        component: () => import("@/views/os-system/index.vue"),
        meta: { title: "系统管理", icon: "Key" }
      },
    ]
  } as unknown as RouteRecordRaw,

    {
    path: "/os-log",
    redirect: "/os-log/list",
    component: Layout,
    hidden: true,
    children: [
      {
        path: "list",
        name: "osLog",
        component: () => import("@/views/os-log/index.vue"),
        meta: { title: "日志", icon: "Key" }
      },
    ]
  } as unknown as RouteRecordRaw,


  // 404 页面必须放在最后 !!!
  // { path: '/:pathMatch(.*)*', redirect: '/404', hidden: true } as unknown as RouteRecordRaw
]

const router = createRouter({
  history: createWebHistory(),
  routes: constantRoutes,
  scrollBehavior: () => ({ top: 0 })
})

export function resetRouter() {
  const newRouter = createRouter({
    history: createWebHistory(),
    routes: constantRoutes,
    scrollBehavior: () => ({ top: 0 })
  })
  // @ts-ignore
  router.matcher = newRouter.matcher
}

export default router
