import router from './router'
import {useUserStore} from './store/user'
import {getToken} from '@/utils/auth'
import NProgress from 'nprogress'
import 'nprogress/nprogress.css'

// NProgress 配置
NProgress.configure({showSpinner: false})

// 白名单路由
const whiteList = ['/login', '/404']

router.beforeEach(async (to, from, next) => {
    // 开始进度条
    NProgress.start()

    const userStore = useUserStore()
    const hasToken = getToken();

    if (hasToken) {
        if (to.path === '/login') {
            // 已登录，重定向到首页
            next({path: '/'})
            NProgress.done()
        } else {
            // 确定用户是否有用户信息
            const hasGetUserInfo = userStore.name !== ''
            if (hasGetUserInfo) {
                next()
            } else {
                try {
                    // 获取用户信息
                    await userStore.getInfo()
                    next()
                } catch (error) {
                    // 移除令牌并重新登录
                    await userStore.resetToken()
                    next(`/login?redirect=${to.path}`)
                    NProgress.done()
                }
            }
        }
    } else {
        // 没有令牌
        if (whiteList.indexOf(to.path) !== -1) {
            // 在白名单中直接通过
            next()
        } else {
            // 重定向到登录页
            next(`/login?redirect=${to.path}`)
            NProgress.done()
        }
    }
})

router.afterEach(() => {
    // 完成进度条
    NProgress.done()
})
