import { request, POST } from '@/utils/request'
import type { ApiResponse, QueryParams } from '@/utils/request'
import { scheduleApi, scrapydServerApi } from './apiPaths'

// 添加调度任务
export function addJob(data: Record<string, any>): Promise<ApiResponse> {
  return request({
    url: scheduleApi.addJob,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取调度任务列表
export function getJobs(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scheduleApi.getJobs,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 暂停调度任务
export function pauseJob(data: Record<string, any>): Promise<ApiResponse> {
  return request({
    url: scheduleApi.pauseJob,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 恢复调度任务
export function resumeJob(data: Record<string, any>): Promise<ApiResponse> {
  return request({
    url: scheduleApi.resumeJob,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 删除调度任务
export function removeJob(data: Record<string, any>): Promise<ApiResponse> {
  return request({
    url: scheduleApi.removeJob,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取调度任务详情
export function getJobDetail(data: QueryParams): Promise<ApiResponse> {
  return request({
    url: scheduleApi.jobDetail,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取调度器状态
export function getScheduleState(): Promise<ApiResponse> {
  return request({
    url: scheduleApi.state,
    method: POST,
  }) as unknown as Promise<ApiResponse>
}

// 启动调度器
export function startSchedule(): Promise<ApiResponse> {
  return request({
    url: scheduleApi.start,
    method: POST
  }) as unknown as Promise<ApiResponse>
}

// 关闭调度器
export function shutdownSchedule(): Promise<ApiResponse> {
  return request({
    url: scheduleApi.shutdown,
    method: POST
  }) as unknown as Promise<ApiResponse>
}

// 暂停调度器
export function pauseSchedule(): Promise<ApiResponse> {
  return request({
    url: scheduleApi.pause,
    method: POST
  }) as unknown as Promise<ApiResponse>
}

// 恢复调度器
export function resumeSchedule(): Promise<ApiResponse> {
  return request({
    url: scheduleApi.resume,
    method: POST
  }) as unknown as Promise<ApiResponse>
}

// 删除所有调度任务
export function removeAllJobs(): Promise<ApiResponse> {
  return request({
    url: scheduleApi.removeAllJobs,
    method: POST
  }) as unknown as Promise<ApiResponse>
}

// 获取调度日志
export function getScheduleLogs(data: Record<string, any>): Promise<ApiResponse> {
  return request({
    url: scheduleApi.scheduleLogs,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 删除调度日志
export function removeScheduleLogs(data: Record<string, any> = {}): Promise<ApiResponse> {
  return request({
    url: scheduleApi.removeScheduleLogs,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取Scrapyd服务列表
export function getScrapydServerPage(): Promise<ApiResponse> {
  return request({
    url: scrapydServerApi.getScrapydServerPage,
    method: POST,
  }) as unknown as Promise<ApiResponse>
}
