import { createApp } from "vue";
import "virtual:uno.css";
import App from "./App.vue";
import router from "./router";
import pinia from "./store";
import ElementPlus from "element-plus";
import "element-plus/dist/index.css";
import {
  UserFilled,
  Lock,
  View,
  Hide,
  CaretBottom,
  HomeFilled,
  Menu,
  Document,
  Tickets,
  List,
  Folder,
  Files,
  Loading,
  VideoPlay,
  Refresh,
  Back,
  Upload,
  Plus,
  Monitor,
  Key,
  House,
  Clock,
  Message,
  DataAnalysis,
  Notebook,
  Setting,
} from "@element-plus/icons-vue";
import "normalize.css/normalize.css";
import "./styles/index.scss";
import "./style.css";
import "./permission"; // 权限控制
import "animate.css";

const app = createApp(App);

// 注册 Element Plus 图标
app.component("Monitor", Monitor);
app.component("Document", Document);
app.component("List", List);
app.component("Key", Key);
app.component("House", House);
app.component("Clock", Clock);
app.component("Message", Message);
app.component("DataAnalysis", DataAnalysis);
app.component("Notebook", Notebook);
app.component("Setting", Setting);

app.component("UserFilled", UserFilled);
app.component("Lock", Lock);
app.component("View", View);
app.component("Hide", Hide);
app.component("CaretBottom", CaretBottom);
app.component("HomeFilled", HomeFilled);
app.component("Menu", Menu);
app.component("Tickets", Tickets);
app.component("Folder", Folder);
app.component("Files", Files);
app.component("Loading", Loading);
app.component("VideoPlay", VideoPlay);
app.component("Refresh", Refresh);
app.component("Back", Back);
app.component("Upload", Upload);
app.component("Plus", Plus);

app.use(router);
app.use(pinia);
app.use(ElementPlus, { size: "default" });

app.mount("#app");
