import { request, POST } from '@/utils/request'
import type { ApiResponse, UserQueryParams } from '@/utils/request'
import { authApi,userApi } from './apiPaths'

// 用户登录
export function login(data: { username: string, password: string }): Promise<ApiResponse> {
  return request({
    url: authApi.login,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 获取用户信息
export function getInfo() {
  return new Promise(resolve => {
    resolve({
      data: {
        roles: ['admin'],
        introduction: 'Admin',
        avatar: 'user-avatar.gif',
        name: 'Admin'
      }
    })
  })
}

// 用户登出
export function logout(): Promise<ApiResponse> {
  return request({
    url: authApi.logout,
    method: POST
  }) as unknown as Promise<ApiResponse>
}

// 获取用户列表
export function getUserList(data: UserQueryParams) {
  return request({
    url: userApi.userList,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 新建用户
export function addUser(data: UserQueryParams) {
  return request({
    url: userApi.addUser,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 更新用户
export function updateUser(data: UserQueryParams) {
  return request({
    url: userApi.updateUser,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 删除用户
export function deleteUser(data: UserQueryParams) {
  return request({
    url: userApi.deleteUser,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 批量删除用户
export function batchDeleteUser(data: UserQueryParams) {
  return request({
    url: userApi.batchDelete,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}