import { defineStore } from 'pinia'
import defaultSettings from '@/settings'

const { fixedHeader, sidebarLogo } = defaultSettings

interface SettingsState {
  fixedHeader: boolean
  sidebarLogo: boolean
}

export const useSettingsStore = defineStore('settings', {
  state: (): SettingsState => ({
    fixedHeader,
    sidebarLogo
  }),
  actions: {
    changeSetting({ key, value }: { key: string, value: any }) {
      // @ts-ignore
      this[key] = value
    }
  }
})
