import { defineConfig } from 'vite'
import UnoCSS from 'unocss/vite'
import vue from '@vitejs/plugin-vue'
import { resolve } from 'path'

// https://vite.dev/config/
export default defineConfig({
  plugins: [
    vue(),
    UnoCSS()
  ],
  resolve: {
    alias: {
      '@': resolve(__dirname, 'src'),
    }
  },
  css: {
    preprocessorOptions: {
      scss: {
        additionalData: `
          @use "@/styles/_variables.scss" as *;
          @use "@/styles/_mixin.scss" as *;
        `
      }
    }
  },
  base: './',
  server: {
    host: '0.0.0.0',
    port: 9529,
    proxy: {
      // 代理API请求，使用更精确的路径匹配
      '/api': {
        target: 'http://127.0.0.1:5001/',
        changeOrigin: true,
      },
    }
  }
})
