import { request, POST } from '@/utils/request'
import type { ApiResponse, QueryParams ,UserQueryParams } from '@/utils/request'
import { systemApi, scrapydServerApi, spiderApi,spiderTaskApi} from './apiPaths'

// 爬虫任务执行记录
export function getSpiderTaskRecord(data: UserQueryParams) {
  return request({
    url: spiderTaskApi.taskRecord,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}

// 爬虫任务列表
export function getSpiderTaskList(data: UserQueryParams) {
  return request({
    url: spiderTaskApi.taskList,
    method: POST,
    data
  }) as unknown as Promise<ApiResponse>
}