const formatExactLargeNum = (num: number | string) => {
  if (num === null || num === undefined) return num;
  if (typeof num !== "number" && typeof num !== "string") return num;

  const parsedNum = typeof num === "string" ? Number(num.replace(/,/g, "")) : num;

  if (isNaN(parsedNum)) return num;

  if (Math.abs(parsedNum) > 100000000) {
    return parsedNum.toExponential(2);
  } else {
    return parsedNum.toLocaleString("en-US", {
      useGrouping: true,
      maximumFractionDigits: 0,
      minimumFractionDigits: 0,
    });
  }
};

export default formatExactLargeNum;
