const formatExactLargeNum = (num: number | string | null) => {
  if (num === null || num === undefined) return "";
  if (typeof num !== "number" && typeof num !== "string") return num;

  const parsedNum = typeof num === "string" ? Number(num.replace(/,/g, "")) : num;

  if (isNaN(parsedNum)) return num;

  // 如果大于 100 万 或大于 1 亿，使用科学计数法
  if (Math.abs(parsedNum) > 1_000_000) {
    return parsedNum.toExponential(2);
  } else {
    return parsedNum.toLocaleString("en-US", {
      useGrouping: true,
      maximumFractionDigits: 0,
      minimumFractionDigits: 0,
    });
  }
};

export default formatExactLargeNum;
