import csv
import glob
from sqlalchemy import create_engine, select
from configparser import ConfigParser
from mysql_model import *


parser = ConfigParser()
parser.read('config.ini', encoding='utf-8')
username = parser.get('mysql_base', 'user')
password = parser.get('mysql_base', 'password')
host = parser.get('mysql_base', 'host')
port = parser.get('mysql_base', 'port')

tables_name = ["alarm_attribution", "history_alarm", "current_alarm", "per_attribution", "history_performance", "log_info", "current_performance"]
tables = [AlarmAttribution, HistoryAlarm, CurrentAlarm, PerformanceAttribution, HistoryPerformance, LogInfo, CurrentPerformance]
headers = []

for table in tables:
    cloumns = []
    for col in table.__table__.columns:
        if col.name != 'id':
            cloumns.append(col.name)
    headers.append(cloumns)


# ===============================================================
# 
#                  mysql data to csv
# 
# ===============================================================
mysql_database_items = parser.items('mysql')
for _, database in mysql_database_items:
    print(f'======== {database} ========')
    # 创建一个 MySQL 连接引擎
    engine = create_engine(f'mysql+pymysql://{username}:{password}@{host}:{port}/{database}')

    # 测试连接
    conn = engine.connect()
    for idx, table in enumerate(tables):
        items = conn.execute(select([table]))
    
        with open(f'./data/{database}_{tables_name[idx]}.csv', 'w', encoding='utf-8', newline='') as f:
            writer = csv.writer(f)

            # 写入表头行
            writer.writerow(headers[idx])

            for j, item in enumerate(items):
                writer.writerow(list(item[1:]))
                # 貌似是个 tuple
    # 关闭连接
    conn.close()

# ===============================================================
# 
#                  csv data to postgresql
#
# ===============================================================

# 打开 CSV 文件，创建一个阅读器对象
username = parser.get('postgresql_base', 'user')
password = parser.get('postgresql_base', 'password')
host = parser.get('postgresql_base', 'host')
port = parser.get('postgresql_base', 'port')
postgresql_database_items = parser.items('postgresql')

for _, database in postgresql_database_items:
    print(f'======== {database} ========')
    # 创建一个 PostgreSQL 连接引擎
    engine = create_engine(f'postgresql://{username}:{password}@{host}:{port}/{database}')
    conn = engine.connect()

    for idx, table in enumerate(tables):
        with open(glob.glob(f'./data/*oam_{database[:3]}_{tables_name[idx]}.csv')[0], mode='r', encoding='utf-8', newline='') as file:
            reader = csv.reader(file)

            # 读取表头行
            header = next(reader)

            item_list = []
            # 读取数据
            for i, row in enumerate(reader):
                item_dict = dict(zip(header, row))
                item_list.append(item_dict)

        if len(item_list) > 0:
            conn.execute(table.__table__.insert(), item_list)
    conn.close()
