from sqlalchemy import BigInteger, Column, DECIMAL, DateTime, Integer, String
from sqlalchemy.ext.declarative import declarative_base

Base = declarative_base()


class PrintFields:
    def __repr__(self):
        string = f'<{self.__class__.__name__} ('
        for field in self.__table__.columns:
            string += f'{field.name}={getattr(self, field.name)}, '
        string += ')>'
        return string


class AlarmAttribution(PrintFields, Base):
    __tablename__ = 'alarm_attribution'

    id = Column(BigInteger, primary_key=True, comment='序号，自增')
    alarmid = Column(BigInteger, comment='告警 ID')
    alarmlevel = Column(String(30), comment='告警级别')
    alarmdescriptionchn = Column(String(255),
                                   comment='中文描述，应该描述故障现象 和解决问题的方法')
    alarmdescriptioneng = Column(String(255), comment='英文描述')
    ismon = Column(Integer, comment='是否监视')
    updatetime = Column(String(20), comment='最新更新时间')

    def __repr__(self):
        return super().__repr__()

    @property
    def alarm_id(self):
        return self.alarmid
    @alarm_id.setter
    def alarm_id(self, value):
        self.alarmid = value

    @property
    def alarm_level(self):
        return self.alarmlevel
    @alarm_level.setter
    def alarm_level(self, value):
        self.alarmlevel = value

    @property
    def alarm_description_chn(self):
        return self.alarmdescriptionchn
    @alarm_description_chn.setter
    def alarm_description_chn(self, value):
        self.alarmdescriptionchn = value

    @property
    def alarm_description_eng(self):
        return self.alarmdescriptioneng
    @alarm_description_eng.setter
    def alarm_description_eng(self, value):
        self.alarmdescriptioneng = value

    @property
    def is_monitor(self):
        return self.ismon
    @is_monitor.setter
    def is_monitor(self, value):
        self.ismon = value

    @property
    def update_time(self):
        return self.updatetime
    @update_time.setter
    def update_time(self, value):
        self.updatetime = value


class CurrentAlarm(PrintFields, Base):
    __tablename__ = 'current_alarm'

    id = Column(BigInteger, primary_key=True, comment='告警序号')
    alarmid = Column(BigInteger, comment='告警 ID，取自告警配置列表中的 ID')
    stationid = Column(Integer, comment='告警源头，SUID 标识')
    deviceid = Column(Integer, comment='告警子设备')
    alarmlevel = Column(String(30))
    alarmdescriptionchn = Column(String(255), comment='告警描述')
    alarmdescriptioneng = Column(String(255))
    reporttime = Column(String(20), comment='告警产生时间')

    def __repr__(self):
        return super().__repr__()

    @property
    def alarm_id(self):
        return self.alarmid
    @alarm_id.setter
    def alarm_id(self, value):
        self.alarmid = value

    @property
    def station_id(self):
        return self.stationid
    @station_id.setter
    def station_id(self, value):
        self.stationid = value
    
    @property
    def device_id(self):
        return self.deviceid
    @device_id.setter
    def device_id(self, value):
        self.deviceid = value

    @property
    def alarm_level(self):
        return self.alarmlevel
    @alarm_level.setter
    def alarm_level(self, value):
        self.alarmlevel = value

    @property
    def alarm_description_chn(self):
        return self.alarmdescriptionchn
    @alarm_description_chn.setter
    def alarm_description_chn(self, value):
        self.alarmdescriptionchn = value

    @property
    def alarm_description_eng(self):
        return self.alarmdescriptioneng
    @alarm_description_eng.setter
    def alarm_description_eng(self, value):
        self.alarmdescriptioneng = value

    @property
    def report_time(self):
        return self.reporttime
    @report_time.setter
    def report_time(self, value):
        self.reporttime = value


class CurrentPerformance(PrintFields, Base):
    __tablename__ = 'current_performance'

    id = Column(BigInteger, primary_key=True)
    perid = Column(Integer)
    stationid = Column(Integer)
    deviceid = Column(Integer)
    datacatlog = Column(String(100))
    fieldname = Column(String(40))
    fieldvalue = Column(String(40))
    perdescriptionchn = Column(String(255))
    perdescriptioneng = Column(String(255))
    updatetime = Column(String(20))

    def __repr__(self):
        return super().__repr__()

    @property
    def performance_id(self):
        return self.perid
    @performance_id.setter
    def performance_id(self, value):
        self.perid = value

    @property
    def station_id(self):
        return self.stationid
    @station_id.setter
    def station_id(self, value):
        self.stationid = value

    @property
    def device_id(self):
        return self.deviceid
    @device_id.setter
    def device_id(self, value):
        self.deviceid = value

    @property
    def data_cat_log(self):
        return self.datacatlog
    @data_cat_log.setter
    def data_cat_log(self, value):
        self.datacatlog = value

    @property
    def field_name(self):
        return self.fieldname
    @field_name.setter
    def field_name(self, value):
        self.fieldname = value

    @property
    def field_value(self):
        return self.fieldvalue
    @field_value.setter
    def field_value(self, value):
        self.fieldvalue = value

    @property
    def performance_description_chn(self):
        return self.perdescriptionchn
    @performance_description_chn.setter
    def performance_description_chn(self, value):
        self.perdescriptionchn = value

    @property
    def performance_description_eng(self):
        return self.perdescriptioneng
    @performance_description_eng.setter
    def performance_description_eng(self, value):
        self.perdescriptioneng = value
    
    @property
    def update_time(self):
        return self.updatetime
    @update_time.setter
    def update_time(self, value):
        self.updatetime = value


class HistoryAlarm(PrintFields, Base):
    __tablename__ = 'history_alarm'

    id = Column(BigInteger, primary_key=True)
    alarmid = Column(Integer, comment='告警 ID，取自告警配置列表中的 ID')
    stationid = Column(Integer, comment='告警源头，SUID标识')
    deviceid = Column(Integer)
    alarmlevel = Column(String(30))
    alarmdescriptionchn = Column(String(255))
    alarmdescriptioneng = Column(String(255))
    starttime = Column(String(30), comment='告警产生时间 ')
    endtime = Column(String(20), comment='告警结束时间')

    def __repr__(self):
        return super().__repr__()

    @property
    def alarm_id(self):
        return self.alarmid
    @alarm_id.setter
    def alarm_id(self, value):
        self.alarmid = value
    
    @property
    def station_id(self):
        return self.stationid
    @station_id.setter
    def station_id(self, value):
        self.stationid = value

    @property
    def device_id(self):
        return self.deviceid
    @device_id.setter
    def device_id(self, value):
        self.deviceid = value

    @property
    def alarm_level(self):
        return self.alarmlevel
    @alarm_level.setter
    def alarm_level(self, value):
        self.alarmlevel = value
    
    @property
    def alarm_description_chn(self):
        return self.alarmdescriptionchn
    @alarm_description_chn.setter
    def alarm_description_chn(self, value):
        self.alarmdescriptionchn = value
    
    @property
    def alarm_description_eng(self):
        return self.alarmdescriptioneng
    @alarm_description_eng.setter
    def alarm_description_eng(self, value):
        self.alarmdescriptioneng = value

    @property
    def start_time(self):
        return self.starttime
    @start_time.setter
    def start_time(self, value):
        self.starttime = value
    
    @property
    def end_time(self):
        return self.endtime
    @end_time.setter
    def end_time(self, value):
        self.endtime = value


class LogInfo(PrintFields, Base):
    __tablename__ = 'log_info'

    id = Column(BigInteger, primary_key=True)
    stationid = Column(Integer)
    deviceid = Column(Integer)
    manipunator = Column(String(20))
    loglevel = Column(String(20))
    classification = Column(String(20))
    loginfochn = Column(String(500))
    loginfoeng = Column(String(500))
    reporttime = Column(String(20))

    def __repr__(self):
        return super().__repr__()

    @property
    def station_id(self):
        return self.stationid
    @station_id.setter
    def station_id(self, value):
        self.stationid = value

    @property
    def device_id(self):
        return self.deviceid
    @device_id.setter
    def device_id(self, value):
        self.deviceid = value

    @property
    def log_level(self):
        return self.loglevel
    @log_level.setter
    def log_level(self, value):
        self.loglevel = value

    @property
    def log_info_chn(self):
        return self.loginfochn
    @log_info_chn.setter
    def log_info_chn(self, value):
        self.loginfochn = value

    @property
    def log_info_eng(self):
        return self.loginfoeng
    @log_info_eng.setter
    def log_info_eng(self, value):
        self.loginfoeng = value

    @property
    def report_time(self):
        return self.reporttime
    @report_time.setter
    def report_time(self, value):
        self.reporttime = value


class PerformanceAttribution(PrintFields, Base):
    __tablename__ = 'per_attribution'

    id = Column(BigInteger, primary_key=True)
    perid = Column(BigInteger)
    datacatlog = Column(String(100))
    fieldname = Column(String(50))
    perdescriptionchn = Column(String(255))
    perdescriptioneng = Column(String(255))
    ismon = Column(Integer)
    isfixed = Column(Integer)
    fieldunit = Column(String(20))
    fieldtype = Column(String(20))
    operator1 = Column(String(20))
    operand1 = Column(String(20))
    relation = Column(String(20))
    operator2 = Column(String(20))
    operand2 = Column(String(20))
    alarmlevel = Column(String(20))
    alarmdeschn = Column(String(255))
    alarmdeseng = Column(String(255))
    updatetime = Column(String(20))

    def __repr__(self):
        return super().__repr__()

    @property
    def performance_id(self):
        return self.perid
    @performance_id.setter
    def performance_id(self, value):
        self.perid = value

    @property
    def data_cat_log(self):
        return self.datacatlog
    @data_cat_log.setter
    def data_cat_log(self, value):
        self.datacatlog = value
    
    @property
    def field_name(self):
        return self.fieldname
    @field_name.setter
    def field_name(self, value):
        self.fieldname = value

    @property
    def performance_description_chn(self):
        return self.perdescriptionchn
    @performance_description_chn.setter
    def performance_description_chn(self, value):
        self.perdescriptionchn = value
    
    @property
    def performance_description_eng(self):
        return self.perdescriptioneng
    @performance_description_eng.setter
    def performance_description_eng(self, value):
        self.perdescriptioneng = value

    @property
    def is_monitor(self):
        return self.ismon
    @is_monitor.setter
    def is_monitor(self, value):
        self.ismon = value
    
    @property
    def is_fixed(self):
        return self.isfixed
    @is_fixed.setter
    def is_fixed(self, value):
        self.isfixed = value

    @property
    def field_unit(self):
        return self.fieldunit
    @field_unit.setter
    def field_unit(self, value):
        self.fieldunit = value

    @property
    def field_type(self):
        return self.fieldtype
    @field_type.setter
    def field_type(self, value):
        self.fieldtype = value

    @property
    def alarm_level(self):
        return self.alarmlevel
    @alarm_level.setter
    def alarm_level(self, value):
        self.alarmlevel = value

    @property
    def alarm_description_chn(self):
        return self.alarmdeschn
    @alarm_description_chn.setter
    def alarm_description_chn(self, value):
        self.alarmdeschn = value
    
    @property
    def alarm_description_eng(self):
        return self.alarmdeseng
    @alarm_description_eng.setter
    def alarm_description_eng(self, value):
        self.alarmdeseng = value

    @property
    def update_time(self):
        return self.updatetime
    @update_time.setter
    def update_time(self, value):
        self.updatetime = value


# TODO: add history performance
class HistoryPerformance(PrintFields, Base):
    __tablename__ = 'history_performance'

    id = Column(Integer, primary_key=True)
    suid = Column(Integer)
    value = Column(String(100))
    time = Column(String(30))

    def __repr__(self):
        return super().__repr__()