package org.linker.springboot.vo;

import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;

/**
 * 用户 VO
 */
public class UserVO {

    /**
     * 编号
     */
    @NotNull(message = "编号不能为空")
    @Min(1)
    private Integer id;
    /**
     * 账号
     */
    @NotNull(message = "账号不能为空")
    @Size(min = 4, max = 10, message = "账号长度必须在 {min} - {max} 之间")
    private String username;

    public Integer getId() {
        return id;
    }

    public UserVO setId(Integer id) {
        this.id = id;
        return this;
    }

    public String getUsername() {
        return username;
    }

    public UserVO setUsername(String username) {
        this.username = username;
        return this;
    }

    @Override
    public String toString() {
        return "UserVO{" +
                "id=" + id +
                ", username='" + username + '\'' +
                '}';
    }
}
