package org.linker.springboot.config;

import org.linker.springboot.core.interceptor.FirstInterceptor;
import org.linker.springboot.core.interceptor.SecondInterceptor;
import org.linker.springboot.core.interceptor.ThirdInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SpringMVCConfiguration implements WebMvcConfigurer {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Bean
    public FirstInterceptor firstInterceptor() {
        return new FirstInterceptor();
    }

    @Bean
    public SecondInterceptor secondInterceptor() {
        return new SecondInterceptor();
    }

    @Bean
    public ThirdInterceptor thirdInterceptor() {
        return new ThirdInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
//        // 拦截器一
//        registry.addInterceptor(this.firstInterceptor()).addPathPatterns("/**");
//        // 拦截器二
//        registry.addInterceptor(this.secondInterceptor()).addPathPatterns("/users/current_user");
//        // 拦截器三
//        registry.addInterceptor(this.thirdInterceptor()).addPathPatterns("/**");
    }
}
