## 介绍

- master 分支，主要为后端接口
- fh 分支，为界面

![1692668065114](image/README/1692668065114.png)

各个文件夹或文件作用

- chat：测试 websocket 的模块
- device_communication：device 通信参数模块
- device_data_op：对 device 已有的表的操作模块
- download_db：测试 下载 sqlite 文件模块
- frontend：前端文件夹
- mqtt：测试 mqtt 连接与发送内容的模块
- protocol_version_manage：协议版本控制模块
- scripts_generate：测试 脚本生成模块
- vue_django：django 项目主模块
- db.sqlite3：没用
- manage.py：django 项目启动文件
- poetry.lock，pyproject.toml：poetry 的管理文件
- xdc.sqlite：device 数据库

## 安装依赖

1. 创建 conda 的虚拟环境

   ```
   conda create -n django-venv python=3.9.16
   ```
2. 激活 django-venv 虚拟环境

   ```
   conda activate django-venv
   ```

   可以使用 pip list 查看是否为一个新的环境
3. 激活虚拟环境后下载 poetry

   ```
   pip install poetry
   ```
4. 使用 poetry 命令下载依赖

   ```
   poetry install
   ```
5. 转到 frontend 文件夹，下载前端的依赖（node 版本最低为16，我这里使用的是 16.20.1）

   ```
   yarn install
   ```

   或

   ```
   npm install
   ```
6. 下载完依赖之后打包项目

   ```
   yarn build
   ```

   或

   ```
   npm run build
   ```
7. 退回到 vue_django_test 文件夹，启动项目，就能正常看见页面了

   ```
   python manage.py runserver
   ```

ps：以上步骤在 windows 环境和 ubuntu 20.04 下都测试过，都能正常跑起来

## 运行项目

使用 `python manage.py runserver` 运行项目（目前运行项目只有接口，可能只能通过接口调试工具来测试）

![1692841750241](image/README/1692841750241.png)

## 注意

* 如果是在远程的情况下，需要将 vue_django 目录中 urls.py 文件中的 `mqtt` 和 `chat` url 给注释了，否则启动不成功
  * ![1692841883700](image/README/1692841883700.png)
