import { defineStore } from 'pinia'
import { ref } from 'vue'

type ProtocolVersion = {
    protocol_name: string
    version_paths: string
}

type CurrentVersion = {
    protocol_name: string
    version: string
}

export const useProtocolVersionStore = defineStore('protocolVersion', () => {
    const protocolVersions = ref<ProtocolVersion[]>([])
    const currentVersions = ref<CurrentVersion[]>([])

    return {
        protocolVersions,
        currentVersions
    }

})