import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import legacy from '@vitejs/plugin-legacy'
import { resolve } from 'path'
import process from 'process'

function pathResolve(dir: string): string {
  return resolve(process.cwd(), '.', dir)
};

// https://vitejs.dev/config/
export default defineConfig({
  resolve: {
    alias: {
      "@": pathResolve('src')
    }
  },
  plugins: [
    legacy({
      targets: ['defaults', 'not IE 11'],
    }),
    vue()
  ],
  base:  './',
  server: {
    host: '0.0.0.0',
    port: 8000,
  }
})
