"""vue_django URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path, include, re_path
from .views import index, test

from django.conf import settings
from django.views.static import serve

from drf_yasg.views import get_schema_view
from drf_yasg import openapi

schema_view = get_schema_view(
    openapi.Info(
        title="My API",
        default_version='v1',
        description="My API description",
    ),
    public=True,
)

urlpatterns = [
    path('admin/', admin.site.urls),
    path("", index),
    # path("test/", test),
    path("mqtt/", include("mqtt.urls")),
    path("chat/", include("chat.urls")),
    path("op/", include("device_data_op.urls")),
    path("api/", include("download_db.urls")),

    re_path(r'^assets/(?P<path>.*)/$', serve, {'document_root': settings.STATIC_ROOT}),

    re_path(r'^swagger/$', schema_view.with_ui('swagger', cache_timeout=0), name='schema-swagger-ui'),
]

