from rest_framework.utils.serializer_helpers import ReturnDict, OrderedDict


def tree_data(data: ReturnDict, field_name: str) -> ReturnDict:
    """
    封装数据

    :param data: 原本的数据
    :param parent: 需要收集数据的相同字段名

    :return: 收集到的数据
    """
    
    return_data = {}
    name = set()

    for item in data:
        if item[field_name] not in name:
            name.add(item[field_name])
            return_data[item[field_name]] = []
        return_data[item[field_name]].append(item)

    return_data['fields'] = name
    return return_data
