from django.urls import re_path
from rest_framework.routers import DefaultRouter
from . import views

router = DefaultRouter()
router.register('device_communication/communicate', 
                views.DeviceCommunicationParameterViewSet)
router.register('device_communication/simulate_communicate', 
                views.SimulateDeviceCommunicationParameterViewSet)

urlpatterns = [
    re_path(r'^device_communication/$', views.get_protocol_names),
    re_path(r'^device_communication/protocol_performance/(?P<protocol_name>.+)/$', views.get_protocol_field_names),
    re_path(r'^device_communication/performance/(?P<type>.+)/(?P<protocol_name>.+)/$', 
            views.get_checked_field_names),
    re_path(r'^device_communication/set_communication_to_devinfo_table/$', 
            views.set_communication_to_devinfo_table),
]

urlpatterns += router.urls
