import json
from .auto_generate_python import TDSCmd_pb2, OAM_datastruct_pb2, Device_datastruct_pb2
from .auto_generate_python.Device_datastruct_pb2 import TDSXDC_Device_cmd
from google.protobuf.json_format import MessageToJson


def parse_proto(data: bytes) -> dict:
    cmd = TDSCmd_pb2.TDSCmd()
    cmd.ParseFromString(data)

    device_cmd = TDSXDC_Device_cmd()
    cmd.parameters[0].Unpack(device_cmd)

    data = MessageToJson(device_cmd, 
                         including_default_value_fields=True,
                         preserving_proto_field_name=True)

    device_cmd_dict = json.loads(data)
    data = {item.get('fieldName'): item.get('value') 
            for item in device_cmd_dict['fields']}
    # return json.dumps(json.loads(data), separators=(',', ':'))
    return data

