from django.conf import settings
from django.http import FileResponse, HttpResponse
from rest_framework import status
import os

def index(request):
    file_path = os.path.join(settings.BASE_DIR, 'xdc.sqlite')
    print(f"file path => {file_path}")
    if os.path.exists(file_path):
        response = FileResponse(open(file_path, 'rb'))
        response['Content-Disposition'] = 'inline; filename=' + os.path.basename(file_path)
        response['Content-Type'] = 'application/x-sqlite3'
        return response
    return HttpResponse(status=status.HTTP_404_NOT_FOUND)
