import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import legacy from '@vitejs/plugin-legacy'
import UnoCSS from 'unocss/vite'
import { resolve } from 'path'
import process from 'process'

function pathResolve(dir: string): string {
  return resolve(process.cwd(), '.', dir)
};


// https://vitejs.dev/config/
export default defineConfig({
  resolve: {
    alias: {
      "@": pathResolve('src')
    },
    extensions: ['.ts', '.js', '.vue'] // 使用路径别名时想要省略的后缀名，可以自己 增减
  },
  plugins: [
    legacy({
      targets: ['defaults', 'not IE 11'],
    }),
    vue(),
    UnoCSS({
      configFile: './uno.config.ts'
    })
  ],
  base:  './',
  server: {
    host: '0.0.0.0',
  }
})
