import json

from device_data_op.models import TableAllDevCmdDefine, TableDevCmdNamePoll
from device_data_op.serializers import TableAllDevCmdDefineSerializer, TableDevCmdNamePollSerializer
from django.db.models import QuerySet
from .models import (AllDevCmdDefineAndVersion, AllProtocolDefinAndVersion,
                     AllProtocolVersion, CurrentDevVersion)


INIT_VERSION = "init"


def init_protocol_version_manage(protocol_name) -> None:
    """
    将协议版本信息初始化，即先将 device 已经在用的表的数据添加到数据库表中
    
    :param protocol_name: 协议名
    """
    protocol_cmds = TableDevCmdNamePoll.objects.filter(protocol_name=protocol_name).all()
    protocol_cmds_serializer = TableDevCmdNamePollSerializer(protocol_cmds, many=True)
    all_protocol_objects: list[AllProtocolDefinAndVersion] = []
    for protocol in protocol_cmds_serializer.data:
        protocol['version'] = json.dumps([INIT_VERSION])
        del protocol['id']
        all_protocol_objects.append(AllProtocolDefinAndVersion(**protocol))
    AllProtocolDefinAndVersion.objects.bulk_create(all_protocol_objects)

    cmd_fields: list[QuerySet] = []
    for protocol in protocol_cmds:
        cmd_fields.extend(TableAllDevCmdDefine.objects.filter(cmd_name=protocol.cmd_name).all())
    cmd_fields_serializer = TableAllDevCmdDefineSerializer(cmd_fields, many=True)
    all_cmd_fields_objects: list[AllDevCmdDefineAndVersion] = []
    for cmd_field in cmd_fields_serializer.data:
        cmd_field['version'] = json.dumps([INIT_VERSION])
        del cmd_field['id']
        all_cmd_fields_objects.append(AllDevCmdDefineAndVersion(**cmd_field))
    AllDevCmdDefineAndVersion.objects.bulk_create(all_cmd_fields_objects)
    
    version_path = {
        "version": INIT_VERSION
    }
    AllProtocolVersion.objects.create(protocol_name=protocol_name, 
                                      version_paths=json.dumps([version_path]))
    
    CurrentDevVersion.objects.create(protocol_name=protocol_name,
                                     version=INIT_VERSION)






