import json

from rest_framework.decorators import api_view
from rest_framework.response import Response
from rest_framework import status
from rest_framework.viewsets import GenericViewSet
from rest_framework.mixins import ListModelMixin
from .models import (AllDevCmdDefineAndVersion, AllProtocolDefinAndVersion, 
                     AllProtocolVersion, CurrentDevVersion)
from .serializers import (AllDevCmdDefineAndVersionSerializer, AllProtocolDefinAndVersionSerializer,
                         AllProtocolVersionSerializer, CurrentDevVersionSerializer)
from .utils import init_protocol_version_manage


@api_view(['POST'])
def init(request):
    protocol_name = request.data.get('protocol_name')    
    assert protocol_name is not None, Response(status=status.HTTP_400_BAD_REQUEST)

    all_protocol_version = AllProtocolVersion.objects.filter(protocol_name=protocol_name).first()
    try:
        if all_protocol_version is None:
            # 该协议为空，即没有协议版本信息
            init_protocol_version_manage(protocol_name)
            all_protocol_version = AllProtocolVersion.objects.filter(protocol_name=protocol_name).first()
        # 该协议不为空，即有协议版本信息
        current_protocol_version = CurrentDevVersion.objects.filter(protocol_name=protocol_name).first()
        data = json.loads(all_protocol_version.version_paths)
        res_data = {
            'version_paths': data,
            'current_version': current_protocol_version.version
        }
    except:
        return Response(status=status.HTTP_500_INTERNAL_SERVER_ERROR)

    return Response(data=res_data, status=status.HTTP_200_OK)


class AllProtocolVersionViewSet(GenericViewSet, ListModelMixin):
    queryset = AllProtocolVersion.objects.all()
    serializer_class = AllProtocolVersionSerializer
