import {request} from '/lib/request'

/// 添加用户
// * username : string : 
// * pwd : string : 
// * role : integer : 
//  name : string : 
//  phone : string : 
//  sms : string : 
//  gender : integer : 
//  image : string : 
//  address : string : 
//  extendJson : string : 
export async function UserAdminAdd(params){
	const {data} = await request('/rest/user/admin/add', params)
	return data.data
}

/// 删除冻结用户
// * id : integer : 
// * off : integer : 0-删除，1-冻结，2-解冻
export async function UserAdminDel(params){
	const {data} = await request('/rest/user/admin/del', params)
	return data.data
}

/// 用户信息
// * uid : integer : 
export async function UserAdminInfo(params){
	const {data} = await request('/rest/user/admin/info', params)
	return data.data
}

/// 用户列表
//  departmentId : integer : 
export async function UserAdminList(params){
	const {data} = await request('/rest/user/admin/list', params)
	return data.data
}

/// 用户列表 by role
// * roleId : integer : 
export async function UserAdminListByRole(params){
	const {data} = await request('/rest/user/admin/listByRole', params)
	return data.data
}

/// 修改用户
// * id : integer : 
//  username : string : 
//  name : string : 
//  phone : string : 
//  gender : integer : 
//  image : string : 
//  address : string : 
//  pwd : string : 
//  role : integer : 
//  extendJson : string : 
export async function UserAdminUpdate(params){
	const {data} = await request('/rest/user/admin/update', params)
	return data.data
}

/// 短信验证码获取
// * phone : string : 手机号
export async function UserGetVerifyCode(params){
	const {data} = await request('/rest/user/getVerifyCode', params)
	return data.data
}

/// 用户信息
export async function UserInfo(){
	const {data} = await request('/rest/user/info')
	return data.data
}

/// 登录
//  username : string : 用户名
//  phone : string : 手机号
// * pwd : string : 
//  schema : string : 
export async function UserLogin(params){
	const {data} = await request('/rest/user/login', params)
	return data.data
}

/// 登录-用户名
// * username : string : 用户名
// * pwd : string : 
//  schema : string : 
export async function UserLoginByUsername(params){
	const {data} = await request('/rest/user/loginByUsername', params)
	return data.data
}

/// 登出
export async function UserLogout(){
	const {data} = await request('/rest/user/logout')
	return data.data
}

/// 密码修改
// * oldPwd : string : 
// * newPwd : string : 
export async function UserUpdatePwd(params){
	const {data} = await request('/rest/user/updatePwd', params)
	return data.data
}

/// 更新用户信息
//  username : string : 
//  name : string : 
//  phone : string : 
//  sms : string : 
//  gender : integer : 
//  image : string : 
//  address : string : 
//  oldPwd : string : 
//  newPwd : string : 
//  extendJson : string : 
export async function UserUpdateUserInfo(params){
	const {data} = await request('/rest/user/updateUserInfo', params)
	return data.data
}
