interface ProtocolInfo {
  id: number;
  protocol_name: string;
  cmd_name: string;
  cmd_type: string;
  encode: string;
  timing_cmd_cycle_period: number;
  cmd_explain: string;
}

interface DeviceProtocolResponse {
  [key: string]: ProtocolInfo[];
  fields: any[];
}

enum FieldTypes {
  DATATYPE_DEFAULT = 0,
  DATATYPE_STR = 1,
  DATATYPE_UINT_STR = 2,
  DATATYPE_INT_STR = 3,
  DATATYPE_FLOAT_STR = 4,
  DATATYPE_DOUBLE_STR = 5,
  DATATYPE_HEX = 6,
  DATATYPE_STR_HEX = 7,
  DATATYPE_UINT_HEX = 8,
  DATATYPE_INT_HEX = 9,
  DATATYPE_FLOAT_HEX = 10,
  DATATYPE_DOUBLE_HEX = 11,
  DATATYPE_DOUBLE = 12,
  DATATYPE_PAYLOAD = 13,
  DATATYPE_INT8 = 14,
  DATATYPE_TIMESTR = 15,
  DATATYPE_MAX = 16
}

interface CmdInfo {
  id?: number;
  cmd_name: string;
  cmd_type: string;
  fieldindex: number;
  fieldname: string;
  fieldsize: number;
  value: string;
  minvalue: string;
  maxvalue: string;
  datatype: FieldTypes;
  operation_in: number;
  operation_in_num: number;
  operation_out: number;
  operation_out_num: number;
  operabo_in: number;
  operabo_out: number;
  lua_script_in: string;
  lua_script_out: string;
}

interface ProtocolCmdResponse {
  [key: string]: CmdInfo[];
  fields: any[];
}


export type {
  DeviceProtocolResponse,
  ProtocolCmdResponse,
  CmdInfo,
}