from rest_framework.decorators import api_view
from rest_framework.response import Response
from rest_framework import status

from protocol_version_manage.models import (AllProtocolVersion, AllProtocolDefinAndVersion,
                                            AllDevCmdDefineAndVersion)

@api_view(['GET'])
def get_protocol_names(request):

    protocol_names = AllProtocolVersion.objects.all()
    res_data = ([{'value': protocol_name.protocol_name, 'label': protocol_name.protocol_name} 
                 for protocol_name in protocol_names])

    return Response(data=res_data, status=status.HTTP_200_OK)


@api_view(['POST'])
def get_protocol_field_names(request):
    protocol_name = request.data.get('protocol_name')
    if protocol_name is None or protocol_name == '': 
        return Response(status=status.HTTP_400_BAD_REQUEST)

    # 获取该协议下的指令集合
    cmds = AllProtocolDefinAndVersion.objects.filter(protocol_name=protocol_name, cmd_type='RX').all()
    cmd_set = set([cmd.cmd_name for cmd in cmds])

    # 获取指令集合下的字段
    fields = AllDevCmdDefineAndVersion.objects.filter(cmd_name__in=cmd_set, cmd_type='RX').all()
    field_name_set = set([field.fieldname for field in fields])

    res_data = ([field_name for field_name in field_name_set])
    return Response(data=res_data, status=status.HTTP_200_OK)
