import { InternalAxiosRequestConfig } from 'axios';

// 网络请求响应格式，T 是具体的接口返回类型数据
interface CustomSuccessData<T> {
    code: number;
    msg?: string;
    message?: string;
    data?: T;
    [keys: string]: any;
}

interface Get {
    <T>(url: string, config?: InternalAxiosRequestConfig): Promise<CustomSuccessData<T>>;
}

interface Post {
    <T>(url: string, params?: string | object, config?: InternalAxiosRequestConfig): Promise<CustomSuccessData<T>>;
}

interface Delete {
    <T>(url: string, config?: InternalAxiosRequestConfig): Promise<CustomSuccessData<T>>;
}

interface Put {
    <T>(url: string, params?: string | object, config?: InternalAxiosRequestConfig): Promise<CustomSuccessData<T>>;
}

// ... delete 等等

export type {
    CustomSuccessData,
    Get,
    Post,
    Delete,
    Put
}