import {request} from '/lib/request'

/// 删除
// * id : string : 
export async function NameConfigDel(params){
	const {data} = await request('/rest/nameConfig/del', params)
	return data.data
}

/// 产品详情
// * id : string : 
export async function NameConfigDetail(params){
	const {data} = await request('/rest/nameConfig/detail', params)
	return data.data
}

/// 列表
export async function NameConfigList(){
	const {data} = await request('/rest/nameConfig/list')
	return data.data
}

/// 增加和修改
// * id : string : 
//  name : string : 
//  category : integer : 
//  separator : string : 分隔符
//  postfix : string : 后缀 需要以 . 开头
//  fieldConfig : string : [{index-序号,adType-匹配类型，多条件使用 - (0-不解析，1-固定适配(多值固定适配，value使用预设分隔符隔开)，2-对照表适配，3-日期时间适配,4-小写字母，5-大写字母，6-数字，7-特殊字符,8-自定义正则)，length-字符长度（不限制使用 -1 ），value-根据适配类型解析，分 固定值/对照表/日期格式/特殊字符(除预定的分隔符外的字符)，labelFlag-是否作为特征标签}]
//  outDirConfig : string : 从SWAP的同级目录开始  也可以单独设置
//  extend : string : 
export async function NameConfigUpdate(params){
	const {data} = await request('/rest/nameConfig/update', params)
	return data.data
}

/// 增加和修改
// * id : string : 
//  outDirConfig : string : 从SWAP的同级目录开始
//  extend : string : 
export async function NameConfigUpdateDir(params){
	const {data} = await request('/rest/nameConfig/update/dir', params)
	return data.data
}
