import {download,request} from '/lib/request'
import {configKit} from "../../lib/store";


/// 公共下载
// * name : string : 
export async function ProductsDownload(params,filename){
	await download('/rest/products/download', params,{filename})
}

/// 列表
//  siteNo : string : 
//  start : string : 
//  end : string : 
export async function ProductsList(params){
	const {data} = await request('/rest/products/list', params)
	return data.data
}

/// 可选站点列表
export async function ProductsSiteList(){
	const {data} = await request('/rest/products/site/list')
	return data.data
}
