import {request} from '/lib/request'

/// role新增
// * name : string : 
// * privilegesJson : string : 数组json字符串：[a,b,c]
//  departmentId : integer : 
export async function RoleCreate(params){
	const {data} = await request('/rest/role/create', params)
	return data.data
}

/// role删除
// * id : integer : 
export async function RoleDel(params){
	const {data} = await request('/rest/role/del', params)
	return data.data
}

/// 部门新增
//  no : string : 
// * name : string : 
//  description : string : 
//  parentId : integer : 
export async function RoleDepartmentCreate(params){
	const {data} = await request('/rest/role/department/create', params)
	return data.data
}

/// 部门删除
// * id : integer : 
export async function RoleDepartmentDel(params){
	const {data} = await request('/rest/role/department/del', params)
	return data.data
}

/// 部门列表
export async function RoleDepartmentList(){
	const {data} = await request('/rest/role/department/list')
	return data.data
}

/// 部门修改
// * id : integer : 
//  no : string : 
//  name : string : 
//  description : string : 
//  parentId : integer : 
export async function RoleDepartmentUpdate(params){
	const {data} = await request('/rest/role/department/update', params)
	return data.data
}

/// role列表
//  root : integer : 指定根department
export async function RoleList(params){
	const {data} = await request('/rest/role/list', params)
	return data.data
}

/// 列出所有角色，附带所属users
// * roleId : integer : 
export async function RoleListRolesWithUser(params){
	const {data} = await request('/rest/role/listRolesWithUser', params)
	return data.data
}

/// 所有权限列表
export async function RolePrivilegeList(){
	const {data} = await request('/rest/role/privilege/list')
	return data.data
}

/// role修改
// * id : integer : 
//  name : string : 
//  privilegesJson : string : 数组json字符串：[a,b,c]
//  departmentId : integer : 
export async function RoleUpdate(params){
	const {data} = await request('/rest/role/update', params)
	return data.data
}
