import {request} from '/lib/request'

/// 分类删除
// * id : integer : 
export async function SearchCategoryDel(params){
	const {data} = await request('/rest/search/category/del', params)
	return data.data
}

/// 分类列表
export async function SearchCategoryList(){
	const {data} = await request('/rest/search/category/list')
	return data.data
}

/// 分类增加和修改
//  id : integer : 
//  searchColumnId : integer : 
//  searchKey : string : 
//  name : string : 
//  extend : string : 
export async function SearchCategoryUpdate(params){
	const {data} = await request('/rest/search/category/update', params)
	return data.data
}

/// 栏目删除
// * id : integer : 
export async function SearchColumnDel(params){
	const {data} = await request('/rest/search/column/del', params)
	return data.data
}

/// 栏目列表
//  categoryFlag : boolean : 
export async function SearchColumnList(params){
	const {data} = await request('/rest/search/column/list', params)
	return data.data
}

/// 栏目增加和修改
//  id : integer : 
//  name : string : 
//  extend : string : 
export async function SearchColumnUpdate(params){
	const {data} = await request('/rest/search/column/update', params)
	return data.data
}

/// 产品详情
// * id : integer : 
export async function SearchDetail(params){
	const {data} = await request('/rest/search/detail', params)
	return data.data
}

/// 产品列表
//  searchIdArray : string : 
export async function SearchList(params){
	const {data} = await request('/rest/search/list', params)
	return data.data
}

/// 产品添加备注run
// * id : integer : 
//  remark : string : 
export async function SearchUpdate(params){
	const {data} = await request('/rest/search/update', params)
	return data.data
}
