import type { CmdInfo } from '@/components/protocol/types'
import request from "@/plugins/axios/requests"
import type { DeviceProtocolResponse, ProtocolCmdResponse } from '@/components/protocol/types';

// const baseURL = 'http://192.168.0.214:8000/op' 

export function DeviceProtocol() {
    return request.get<DeviceProtocolResponse>('/api/dev_cmd_name_poll_1/')
}

export function ProtocolCmd() {
    return request.get<ProtocolCmdResponse>('/api/all_dev_cmd_define_1/')
}

export function EditProtocolCmd(id: number, params: any) {
    return request.put('/api/all_dev_cmd_define_1/' + id + '/', params) 
}

export function DeleteProtocolCmd(id: number) {
    return request.del('/api/all_dev_cmd_define_1/' + id + '/')
}

export function AddProtocolCmd(params: any) {
    return request.post<CmdInfo>('/api/all_dev_cmd_define_1/', params)
}