import axios from "axios"
import request from "@/plugins/axios/requests"

// const baseURL = 'http://192.168.0.214:8000/op'

export function GetProtocolVersion() {
  return axios.get('/api/all_protocol_version/').then(
    function (response) {
      return response.data
    }
  )
}

export function ProtocolInit(protocol_name: any) {
  return axios.post('/api/protocol_version_manage/init/', protocol_name).then(
    function (response) {
      return response.data
    }
  )
}

export function GetCurrentVersion() {
  return axios.get('/api/current_versions/').then(
    function (response) {
      return response.data
    }
  )
}

export function removeProtocolDao(protocolName: string) {
  return request.del('/api/protocol/' + protocolName + '/')
}

export function addCmdDao(param: any) {
  return request.post('/api/dev_cmd_name_poll_1/', param)
}

export function removeCmdDao(id: number) {
  return request.del('/api/dev_cmd_name_poll_1/' + id + '/')
}