import service from '@/plugins/axios/axiosConfigs'
import { Get, Post, Delete, Put } from './types'; // 接口泛型

// 封装 get 方法，类型为Get
const get: Get = async (url, config) => {
    const response = await service.get(url, { ...config});
    return response;
};

const post: Post = async (url, params, config) => {
    const response = await service.post(url, params, {...config});
    return response;
};

// 封装 delete 方法
const del: Delete = async (url, config) => {
    const response = await service.delete(url, {...config});
    return response;
}

// 封装 put 方法
const put: Put = async (url, params, config) => {
    const response = await service.put(url, params, {...config});
    return response;
}

// 使用 request 统一调用
const request = {
    get,
    post,
    del,
    put
};

export default request;