from django.db import models

# Create your models here.
class AllDevCmdDefineAndVersion(models.Model):
    id = models.AutoField(primary_key=True)  # Field name made lowercase.
    cmd_name = models.TextField()  # Field name made lowercase.
    cmd_type = models.TextField()  # Field name made lowercase.
    fieldindex = models.IntegerField()  # Field name made lowercase.
    fieldname = models.TextField()  # Field name made lowercase.
    fieldsize = models.IntegerField()  # Field name made lowercase.
    value = models.TextField()
    minvalue = models.TextField()  # Field name made lowercase.
    maxvalue = models.TextField()  # Field name made lowercase.
    datatype = models.IntegerField()  # Field name made lowercase.
    operation_in = models.IntegerField()
    operation_in_num = models.IntegerField()
    operation_out = models.IntegerField()
    operation_out_num = models.IntegerField()
    operabo_in = models.IntegerField()  # Field name made lowercase.
    operabo_out = models.IntegerField()  # Field name made lowercase.
    lua_script_in = models.TextField()  # Field name made lowercase.
    lua_script_out = models.TextField()  # Field name made lowercase.
    version = models.TextField()

    def __hash__(self) -> int:
        return super().__hash__()

    def __eq__(self, __value: object) -> bool:
        if not isinstance(__value, AllDevCmdDefineAndVersion):
            return False
        
        if (self.cmd_name == __value.cmd_name and
            self.cmd_type == __value.cmd_type and
            self.fieldindex == __value.fieldindex and
            self.fieldname == __value.fieldname and
            self.fieldsize == __value.fieldsize and
            self.value == __value.value and
            self.minvalue == __value.minvalue and
            self.maxvalue == __value.maxvalue and
            self.datatype == __value.datatype and
            self.operation_in == __value.operation_in and
            self.operation_in_num == __value.operation_in_num and
            self.operation_out == __value.operation_out and
            self.operation_out_num == __value.operation_out_num and
            self.operabo_in == __value.operabo_in and
            self.operabo_out == __value.operabo_out and
            self.lua_script_in == __value.lua_script_in and
            self.lua_script_out == __value.lua_script_out):
            return True
        
        return False

    class Meta:
        db_table = 'AllDevCmdDefineAndVersion'


class AllProtocolDefinAndVersion(models.Model):
    """
    version 格式
    版本号的列表
    ["20230708", "20230709", "20230710"]
    """
    id = models.AutoField(primary_key=True)  # Field name made lowercase.
    protocol_name = models.TextField()  # Field name made lowercase.
    cmd_name = models.TextField()  # Field name made lowercase.
    cmd_type = models.TextField()  # Field name made lowercase.
    encode = models.TextField()  # Field name made lowercase.
    timing_cmd_cycle_period = models.IntegerField()  # Field name made lowercase.
    cmd_explain = models.TextField()  # Field name made lowercase.
    version = models.TextField()

    def __hash__(self) -> int:
        return super().__hash__()

    def __eq__(self, __value: object) -> bool:
        if not isinstance(__value, AllProtocolDefinAndVersion):
            return False
        
        if (self.protocol_name == __value.protocol_name and
            self.cmd_name == __value.cmd_name and
            self.cmd_type == __value.cmd_type and
            self.encode == __value.encode and
            self.timing_cmd_cycle_period == __value.timing_cmd_cycle_period and
            self.cmd_explain == __value.cmd_explain):
            return True

        return False

    class Meta:
        db_table = 'AllProtocolDefinAndVersion'


class CurrentDevVersion(models.Model):
    protocol_name = models.TextField(primary_key=True)  # Field name made lowercase.
    version = models.TextField()
    
    def __hash__(self) -> int:
        return super().__hash__()


    class Meta:
        db_table = 'CurrentDevVersion'


class AllProtocolVersion(models.Model):
    """
    versions_path 格式
    版本号：版本原始文件所在的路径
    {
        "vesrion": "20230708",
        "path": "/path/to/file"
    }
    """
    protocol_name = models.TextField(primary_key=True)
    version_paths = models.TextField()

    class Meta:
        db_table = 'AllProtocolVersion'

