from django.urls import re_path
from rest_framework.routers import DefaultRouter

from . import views

router = DefaultRouter()    
router.register('current_versions', views.CurrentDevVersionViewSet)
router.register('protocol_version_manage/cmd_fields_manager', 
                views.AllDevCmdDefineAndVersionViewSet)

urlpatterns = [
    re_path(r'^protocol_version_manage/init/$', views.init),
    re_path(r'^protocol_version_manage/change_protocol_version/$', views.change_protocol_version),
    re_path(r'^protocol_version_manage/add_protocol_version/$', views.add_protocol_version),
    re_path(r'^protocol_version_manage/update_protocol_version/$', views.update_protocol_version),
    re_path(r'^protocol_version_manage/file_upload/$', views.raw_file_upload),
    re_path(r'^protocol_version_manage/file_download/(?P<protocol_name>.+)/(?P<version>.+)/$', 
            views.raw_file_download),
    re_path(r'^all_protocol_version/$', views.AllProtocolVersionViewSet.as_view({'get': 'list'})),
    re_path(r'^protocol_vesrion_manage/delete_protocol_vesrion/$', views.delete_protocol_vesrion),
]

urlpatterns += router.urls
