from django.db import models

# Create your models here.
class SimulateDeviceCommunicationParameter(models.Model):
    """
    模拟设备通信参数
    """
    id = models.AutoField(primary_key=True)
    device_name = models.CharField(max_length=100)
    protocol_name = models.CharField(max_length=100)
    communicate_mode = models.CharField(max_length=100)
    tcp_ip = models.CharField(max_length=40)
    tcp_port = models.IntegerField()
    udp_ip_src = models.CharField(max_length=40)
    udp_port_src = models.IntegerField()
    udp_ip_dst = models.CharField(max_length=40)
    udp_port_dst = models.IntegerField()
    performance_fields = models.TextField()

    class Meta:
        db_table = 'Simulate_Device_Communication_Parameter'


class DeviceCommunicationParameter(models.Model):
    """
    设备通信参数
    """
    id = models.AutoField(primary_key=True)
    device_name = models.CharField(max_length=100)
    protocol_name = models.CharField(max_length=100)
    communicate_mode = models.CharField(max_length=100)
    tcp_ip = models.CharField(max_length=40)
    tcp_port = models.IntegerField()
    udp_ip_src = models.CharField(max_length=40)
    udp_port_src = models.IntegerField()
    udp_ip_dst = models.CharField(max_length=40)
    udp_port_dst = models.IntegerField()
    performance_fields = models.TextField()

    class Meta:
        db_table = 'Device_Communication_Parameter'
