from django.db import models


def allow_none(value):
    """
    当传过来的值为 none 时，则在数据库里存一个空值
    
    :param value: 通过基本校验之后的值
    """
    if value == "none":
        return "" 
    return value


# Create your models here.
class SimulateDeviceCommunicationParameter(models.Model):
    """
    模拟设备通信参数
    """
    id = models.AutoField(primary_key=True)
    station_id = models.CharField(max_length=10)
    device_id = models.IntegerField(default=0)
    device_name = models.CharField(max_length=100)
    device_name_chn = models.CharField(max_length=100)
    protocol_name = models.CharField(max_length=100)
    communicate_mode = models.CharField(max_length=100)
    tcp_ip = models.CharField(max_length=40, default="", blank=True)
    tcp_port = models.IntegerField(default=0)
    udp_ip_src = models.CharField(max_length=40, default="", blank=True)
    udp_port_src = models.IntegerField(default=0)
    udp_ip_dst = models.CharField(max_length=40, default="", blank=True)
    udp_port_dst = models.IntegerField(default=0)
    performance_fields = models.TextField()

    def validate(self, attrs: dict):
        """
        校验字段，在进行基础校验之后，如果字段名称为下面的字段，
        且当传过来的值为 none 时，存一个空值
        
        :param attrs: 通过基本校验之后的值
        """
        for field_name, value in attrs.items():
            if field_name in (['tcp_ip', 'tcp_port', 'udp_ip_src', 'udp_port_src', 
                               'udp_ip_dst', 'udp_port_dst']):
                attrs[field_name] = allow_none(value)
        return attrs

    class Meta:
        db_table = 'SimulateDeviceCommunicationParameter'


class DeviceCommunicationParameter(models.Model):
    """
    设备通信参数

    {
        "station_id": "XX1",
        "device_id": 1,
        "device_name": "XXXX",
        "device_name_chn": "XXXX",
        "protocol_name": "HY_VirtualDevice_PROTOCOL",
        "communicate_mode": "TCP_CLIENT",
        "tcp_ip": "127.0.0.1",
        "tcp_port": 8888,
        "performance_fields": ["info", "END", "CMDS"]
    }

    """
    id = models.AutoField(primary_key=True)
    station_id = models.CharField(max_length=10)
    device_id = models.IntegerField(default=0)
    device_name = models.CharField(max_length=100)
    device_name_chn = models.CharField(max_length=100)
    protocol_name = models.CharField(max_length=100)
    communicate_mode = models.CharField(max_length=100)
    tcp_ip = models.CharField(max_length=40, default="", blank=True)
    tcp_port = models.IntegerField(default=0)
    udp_ip_src = models.CharField(max_length=40, default="", blank=True)
    udp_port_src = models.IntegerField(default=0)
    udp_ip_dst = models.CharField(max_length=40, default="", blank=True)
    udp_port_dst = models.IntegerField(default=0)
    performance_fields = models.TextField()

    def validate(self, attrs: dict):
        """
        校验字段，在进行基础校验之后，如果字段名称为下面的字段，
        且当传过来的值为 none 时，存一个空值
        
        :param attrs: 通过基本校验之后的值
        """
        for field_name, value in attrs.items():
            if field_name in (['tcp_ip', 'tcp_port', 'udp_ip_src', 'udp_port_src', 
                               'udp_ip_dst', 'udp_port_dst']):
                attrs[field_name] = allow_none(value)
        return attrs

    class Meta:
        db_table = 'DeviceCommunicationParameter'
