from django.urls import re_path
from . import views

urlpatterns = [
    re_path(r'^device_communication/$', views.get_protocol_names),
    re_path(r'^device_communication/protocol_performance/$', views.get_protocol_field_names),
    re_path(r'^device_communication/set_communication_to_devinfo_table/$', 
            views.set_communication_to_devinfo_table),
    re_path(r'^device_communication/communicate/$', 
            views.DeviceCommunicationParameterViewSet.as_view(
                {'get': 'list', 'post': 'create', 'delete': 'destroy'})),
    re_path(r'^device_communication/simulate_communicate/$', 
            views.SimulateDeviceCommunicationParameterViewSet.as_view(
                {'get': 'list', 'post': 'create', 'delete': 'destroy'})),
]