from django.shortcuts import render
from rest_framework.decorators import api_view, parser_classes
from rest_framework.response import Response
from rest_framework.parsers import MultiPartParser
from rest_framework import status


def index(request):
    return render(request, 'index.html')


@api_view(['GET'])
def test(request):
    if request.method == 'GET':
        return Response({"message": "Hello, World!"})


@api_view(['POST'])
@parser_classes([MultiPartParser])
def upload(request):
    file_obj = request.FILES.get('file')
    protocol_name = request.data.get('protocol_name')
    version = request.data.get('version')
    print(protocol_name)
    print(version)
    print(file_obj.name)
    with open(f'./protocol_raw_files/{protocol_name}/{version}/{file_obj.name}', 'wb+') as destination:
        for chunk in file_obj.chunks():
            destination.write(chunk)
    return Response(status=status.HTTP_200_OK)