from django.shortcuts import render
from rest_framework.response import Response
from rest_framework.viewsets import ModelViewSet
from .models import (TableAllDevCmdDefine, TableDevCmdNamePoll, 
                     TableSoftLimitAngle, TableXproAllDevinfo)
from .serializers import (TableAllDevCmdDefineSerializer, TableDevCmdNamePollSerializer, 
                          TableSoftLimitAngleSerializer, TableXproAllDevinfoSerializer)
from .utils import tree_data


class TableAllDevCmdDefineView(ModelViewSet):
    queryset = TableAllDevCmdDefine.objects.all()
    serializer_class = TableAllDevCmdDefineSerializer

    def list(self, request):
        serializer = self.get_serializer(self.get_queryset(), many=True)
        data = tree_data(serializer.data, 'cmd_name')
        return Response(data)


class TableDevCmdNamePollView(ModelViewSet):
    queryset = TableDevCmdNamePoll.objects.all()
    serializer_class = TableDevCmdNamePollSerializer

    def list(self, request):
        serializer = self.get_serializer(self.get_queryset(), many=True)
        data = tree_data(serializer.data, 'protocol_name')
        return Response(data)
    

class TableSoftLimitAngleView(ModelViewSet):
    queryset = TableSoftLimitAngle.objects.all()
    serializer_class = TableSoftLimitAngleSerializer


class TableXproAllDevinfoView(ModelViewSet):
    queryset = TableXproAllDevinfo.objects.all()
    serializer_class = TableXproAllDevinfoSerializer




