import json
from .auto_generate_python import TDSCmd_pb2, OAM_datastruct_pb2
from google.protobuf.json_format import MessageToJson


def parse_proto(data: bytes) -> str:
    cmd = TDSCmd_pb2.TDSCmd()
    cmd.ParseFromString(data)
    data = MessageToJson(cmd, 
                         including_default_value_fields=True,
                         preserving_proto_field_name=True)
    return json.dumps(json.loads(data), separators=(',', ':'))

